/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeAbstractMinecart;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilityUtils {
    public static <T> LazyOptional<T> findCapabilityAtPos(Capability<T> capability, Level world, BlockPos pos, Direction side, boolean allowCart) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        BlockEntity neighbourTile = world.m_7702_(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(capability, side)).isPresent()) {
            return cap2;
        }
        if (allowCart && BaseRailBlock.m_49364_((Level)world, (BlockPos)pos) && !(list = world.m_6249_((Entity)null, new AABB(pos), entity -> entity instanceof IForgeAbstractMinecart)).isEmpty() && (cap = ((Entity)list.get(world.f_46441_.nextInt(list.size()))).getCapability(capability)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public static LazyOptional<IItemHandler> findItemHandlerAtPos(Level world, BlockPos pos, Direction side, boolean allowCart) {
        return CapabilityUtils.findCapabilityAtPos(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, world, pos, side, allowCart);
    }

    public static LazyOptional<IFluidHandler> findFluidHandlerAtPos(Level world, BlockPos pos, Direction side, boolean allowCart) {
        return CapabilityUtils.findCapabilityAtPos(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, world, pos, side, allowCart);
    }

    public static boolean canInsertStackIntoInventory(BlockEntity inventory, ItemStack stack, Direction side) {
        if (!stack.m_41619_() && inventory != null) {
            return inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> {
                ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.m_41777_(), (boolean)true);
                return temp.m_41619_() || temp.m_41613_() < stack.m_41613_();
            }).orElse(false);
        }
        return false;
    }

    public static ItemStack insertStackIntoInventory(BlockEntity inventory, ItemStack stack, Direction side) {
        if (!stack.m_41619_() && inventory != null) {
            return inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> {
                ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.m_41777_(), (boolean)true);
                if (temp.m_41619_() || temp.m_41613_() < stack.m_41613_()) {
                    return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                }
                return stack;
            }).orElse(stack);
        }
        return stack;
    }

    public static ItemStack insertStackIntoInventory(BlockEntity inventory, ItemStack stack, Direction side, boolean simulate) {
        if (inventory != null && !stack.m_41619_()) {
            return inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.m_41777_(), (boolean)simulate)).orElse(stack);
        }
        return stack;
    }

    public static <T> LazyOptional<T> constantOptional(T val) {
        LazyOptional result = LazyOptional.of(() -> Objects.requireNonNull(val));
        result.resolve();
        return result;
    }

    public static <T> T getPresentCapability(ICapabilityProvider provider, Capability<T> cap) {
        return Objects.requireNonNull(CapabilityUtils.getCapability(provider, cap, null));
    }

    @Nullable
    public static <T> T getCapability(ICapabilityProvider provider, Capability<T> cap) {
        return CapabilityUtils.getCapability(provider, cap, null);
    }

    @Nullable
    public static <T> T getCapability(ICapabilityProvider provider, Capability<T> cap, @Nullable Direction side) {
        LazyOptional optional = provider.getCapability(cap, side);
        if (optional.isPresent()) {
            return (T)optional.orElseThrow(RuntimeException::new);
        }
        return null;
    }
}

